// @input SceneObject collider
// @input Component.Camera cam

var collider = script.collider.getTransform();
var touchPosition;
var zDepth = 80;
var isTouching = false;
var lerpedPosition;

function onUpdate() {
    updateColliderPositions();
}
script.createEvent("UpdateEvent").bind(onUpdate);

function onTouch(eventData) {
    isTouching = true;
    touchPosition = script.cam.screenSpaceToWorldSpace(eventData.getTouchPosition(), zDepth);
}
script.createEvent("TouchStartEvent").bind(onTouch);
script.createEvent("TouchMoveEvent").bind(onTouch);

function touchEnd() {
    isTouching = false;
}
script.createEvent("TouchEndEvent").bind(touchEnd);

function updateColliderPositions() {
    if (isTouching) {
        lerpedPosition = vec3.lerp(touchPosition, collider.getLocalPosition(), 0.5);
        collider.setLocalPosition(touchPosition);
    }
}